# Set variables
$appVersion = "v0.09"
$wallpaperUrlWindows11 = "https://www.geexer.nl/wp-content/uploads/wallpapers/geexerwallpaper.jpg"
$wallpaperUrlWindowsServer = "https://www.geexer.nl/wp-content/uploads/wallpapers/customwindowsserverwallpaper.png"
$downloadsFolderPath = "$env:USERPROFILE\Downloads"
$windowsEdition = (Get-ComputerInfo).WindowsProductName

# Check if PowerShell 7 or later is being used
if ($PSVersionTable.PSVersion.Major -lt 7) {
    Write-Host "PowerShell 7 of later is vereist." -ForegroundColor Red
    Write-Host "Nieuwste vesie van PowerShell wordt nu geinstalleerd.
" -ForegroundColor Yellow
    winget install --id Microsoft.Powershell --source winget --silent --accept-source-agreements --accept-package-agreements
    Clear-Host
    Write-Host "PowerShell 7 is geinstalleerd, sluit dit venster en open PowerShell 7 als Administrator." -ForegroundColor Yellow
    exit 1
}

# Check if the script is running as Administrator
$adminCheck = [System.Security.Principal.WindowsPrincipal]::new(
    [System.Security.Principal.WindowsIdentity]::GetCurrent()
).IsInRole([System.Security.Principal.WindowsBuiltInRole]::Administrator)

if (-not $adminCheck) {
    Write-Host "Open PowerShell als Administrator." -ForegroundColor Red
    exit 1
}

Clear-Host

# Functions
function configureWindows11 {
    # Ask the user if they want to install M365 and save the answer
    do {
        $installOffice = Read-Host "Wil je Office 365 Business installeren? (y/n)"
    
        if ($installOffice -ne "y" -and $installOffice -ne "n") {
            Write-Host "Ongeldige invoer. Typ 'y' voor ja of 'n' voor nee." -ForegroundColor Red
            Start-Sleep -Seconds 2
        }
    } while ($installOffice -ne "y" -and $installOffice -ne "n")
    
    Write-Host "Computer wordt nu geconfigureerd..." -ForegroundColor Cyan
    Start-Sleep -Seconds 10

        # Activate Windows
        # activateWindows

    # Set timezone
    tzutil /s "W. Europe Standard Time"
    Restart-Service w32time
    w32tm /resync

    # Turn on Performance modus
    powercfg -SETACTIVE 8c5e7fda-e8bf-4a96-9a85-a6e23a8c635c
    bcdedit /set hypervisorlaunchtype off

    #Enable ICMP traffic
    netsh advfirewall firewall set rule name="File and Printer Sharing (Echo Request - ICMPv4-In)" new enable=yes
    netsh advfirewall firewall set rule name="File and Printer Sharing (Echo Request - ICMPv4-Out)" new enable=yes

    # Add Exclusions aan Windows Defender
    $downloadsFolderPath = "$env:USERPROFILE\Downloads"
    Add-MpPreference -ExclusionPath $downloadsFolderPath
    Write-Host "De map Downloads is uitgesloten van Windows Defender."
    Add-MpPreference -ExclusionPath "C:\Program Files\ExplorerPatcher"
    Add-MpPreference -ExclusionPath "$env:APPDATA\ExplorerPatcher"
    Add-MpPreference -ExclusionPath "C:\Windows\dxgi.dll"
    Add-MpPreference -ExclusionPath "C:\Windows\SystemApps\Microsoft.Windows.StartMenuExperienceHost_cw5n1h2txyewy"
    Add-MpPreference -ExclusionPath "C:\Windows\SystemApps\ShellExperienceHost_cw5n1h2txyewy"

    ## Configure wallpaper
    # Zorg ervoor dat de map bestaat
    $imageFolderPath = [System.Environment]::GetFolderPath("MyPictures")
    if (-not (Test-Path -Path $imageFolderPath)) {
        New-Item -ItemType Directory -Path $imageFolderPath
    }

    # Pad voor de gedownloade afbeelding
    $imagePath = Join-Path -Path $imageFolderPath -ChildPath "geexerwallpaper.jpg"

    # Download de afbeelding
    Invoke-WebRequest -Uri $wallpaperUrlWindows11 -OutFile $imagePath

    # Laad de benodigde DLL
    Add-Type -TypeDefinition @"
using System;
using System.Runtime.InteropServices;

public class Wallpaper {
    [DllImport("user32.dll", CharSet = CharSet.Auto)]
    public static extern int SystemParametersInfo(int uAction, int uParam, string lpvParam, int fuWinIni);
}
"@

    # Definieer constante waarden
    $SPI_SETDESKWALLPAPER = 20
    $SPIF_UPDATEINIFILE = 0x01
    $SPIF_SENDCHANGE = 0x02

    # Stel de afbeelding in als bureaubladachtergrond
    [Wallpaper]::SystemParametersInfo($SPI_SETDESKWALLPAPER, 0, $imagePath, $SPIF_UPDATEINIFILE -bor $SPIF_SENDCHANGE)

    # Taakbalk uitlijning naar links zetten
    Set-ItemProperty -Path "HKCU:\Software\Microsoft\Windows\CurrentVersion\Explorer\Advanced" -Name "TaskbarAl" -Value 0

    # Zoekbalk instellen op "Alleen zoekpictogram"
    Set-ItemProperty -Path "HKCU:\Software\Microsoft\Windows\CurrentVersion\Search" -Name "SearchboxTaskbarMode" -Value 1

    # Verwijder WebExperience (Weer, Nieuws, etc.)
    Get-AppxPackage -AllUsers | Where-Object { $_.Name -like "*WebExperience*" } | Remove-AppxPackage -AllUsers -ErrorAction SilentlyContinue

    ## Installatie van Apps
    # Chocolatey installeren
    [System.Net.ServicePointManager]::SecurityProtocol = [System.Net.ServicePointManager]::SecurityProtocol -bor 3072
    Invoke-Expression ((New-Object System.Net.WebClient).DownloadString('https://community.chocolatey.org/install.ps1'))

    # Eventuele installatie van M365
    if ($installOffice -eq "y") {

        $officeInstallerPath = [System.IO.Path]::Combine($downloadsFolderPath, "OfficeInstaller.exe")
        Invoke-WebRequest -Uri "https://c2rsetup.officeapps.live.com/c2r/download.aspx?ProductreleaseID=O365BusinessRetail&platform=x64&language=nl-nl&version=O16GA" -OutFile $officeInstallerPath
        Start-Process -FilePath $officeInstallerPath
 
    }

    # Basisapps installeren met Winget
    $apps = @(
        "7zip.7zip",
        "adobe.acrobat.reader.64-bit",
        "google.chrome",
        "videolan.vlc"
    )

    foreach ($app in $apps) {
        winget install $app  --silent --accept-source-agreements --accept-package-agreements
    }

    Clear-Host
    Write-Host "Basisconfiguratie geslaagd" -ForegroundColor Green

    # Update Windows and Apps
    updateWindows
 
    Write-Host
    Clear-Host
    Write-Host "De installatie is gelukt, reboot de computer om af te ronden." -ForegroundColor Yellow
}

function configureWindowsServer {
    Write-Host "Gedetecteerde versie: Windows Server" -ForegroundColor Cyan
    Start-Sleep -Seconds 10

    # Activate Windows
    activateWindows

    # Set timezone
    tzutil /s "W. Europe Standard Time"
    Restart-Service w32time
    w32tm /resync

    # Turn on Performance modus
    powercfg -SETACTIVE 8c5e7fda-e8bf-4a96-9a85-a6e23a8c635c
    bcdedit /set hypervisorlaunchtype off

    #Enable ICMP traffic
    netsh advfirewall firewall set rule name="File and Printer Sharing (Echo Request - ICMPv4-In)" new enable=yes
    netsh advfirewall firewall set rule name="File and Printer Sharing (Echo Request - ICMPv4-Out)" new enable=yes

    # Add Exclusions aan Windows Defender
    $downloadsFolderPath = "$env:USERPROFILE\Downloads"
    Add-MpPreference -ExclusionPath $downloadsFolderPath
    Write-Host " De map Downloads is uitgesloten van Windows Defender."
    Add-MpPreference -ExclusionPath "C:\Program Files\ExplorerPatcher"
    Add-MpPreference -ExclusionPath "$env:APPDATA\ExplorerPatcher"
    Add-MpPreference -ExclusionPath "C:\Windows\dxgi.dll"
    Add-MpPreference -ExclusionPath "C:\Windows\SystemApps\Microsoft.Windows.StartMenuExperienceHost_cw5n1h2txyewy"
    Add-MpPreference -ExclusionPath "C:\Windows\SystemApps\ShellExperienceHost_cw5n1h2txyewy"

    ## Configure wallpaper
    # Zorg ervoor dat de map bestaat
    $imageFolderPath = [System.Environment]::GetFolderPath("MyPictures")
    if (-not (Test-Path -Path $imageFolderPath)) {
        New-Item -ItemType Directory -Path $imageFolderPath
    }

    # Pad voor de gedownloade afbeelding
    $imagePath = Join-Path -Path $imageFolderPath -ChildPath "serverwallpaper.jpg"

    # Download de afbeelding
    Invoke-WebRequest -Uri $wallpaperUrlWindowsServer -OutFile $imagePath

    # Laad de benodigde DLL
    Add-Type -TypeDefinition @"
using System;
using System.Runtime.InteropServices;

public class Wallpaper {
    [DllImport("user32.dll", CharSet = CharSet.Auto)]
    public static extern int SystemParametersInfo(int uAction, int uParam, string lpvParam, int fuWinIni);
}
"@

    # Definieer constante waarden
    $SPI_SETDESKWALLPAPER = 20
    $SPIF_UPDATEINIFILE = 0x01
    $SPIF_SENDCHANGE = 0x02

    # Stel de afbeelding in als bureaubladachtergrond
    [Wallpaper]::SystemParametersInfo($SPI_SETDESKWALLPAPER, 0, $imagePath, $SPIF_UPDATEINIFILE -bor $SPIF_SENDCHANGE)

    # Taakbalk uitlijning naar links zetten
    Set-ItemProperty -Path "HKCU:\Software\Microsoft\Windows\CurrentVersion\Explorer\Advanced" -Name "TaskbarAl" -Value 0

    # Zoekbalk instellen op "Alleen zoekpictogram"
    Set-ItemProperty -Path "HKCU:\Software\Microsoft\Windows\CurrentVersion\Search" -Name "SearchboxTaskbarMode" -Value 1

    # Verwijder WebExperience (Weer, Nieuws, etc.)
    Get-AppxPackage -AllUsers | Where-Object { $_.Name -like "*WebExperience*" } | Remove-AppxPackage -AllUsers -ErrorAction SilentlyContinue

    ## Installatie van Apps
    # Chocolatey installeren
    [System.Net.ServicePointManager]::SecurityProtocol = [System.Net.ServicePointManager]::SecurityProtocol -bor 3072
    Invoke-Expression ((New-Object System.Net.WebClient).DownloadString('https://community.chocolatey.org/install.ps1'))

    # Basisapps installeren met Winget
    $chocoApps = @(
        "7zip",
        "adobereader",
        "googlechrome"
    )

    foreach ($chocoApp in $chocoApps) {
        choco install $chocoApp -y
    }

    Clear-Host
    Write-Host "Basisconfiguratie geslaagd" -ForegroundColor Green

    # Update Windows and Apps
    updateWindows
 
    Write-Host
    Clear-Host
    Write-Host "De installatie is gelukt, reboot om af te ronden." -ForegroundColor Yellow
}

function determineWindowsVersion {    
    Clear-Host
    # Determine Windows type and start configuration
    if ($windowsEdition -like "*Server*") {
        configureWindowsServer

    } else {
        configureWindows11
    }
    Start-Sleep -Seconds 2
}

function addUser {
    # Gewenste useraname configureren
    Clear-Host
    $newUser = Read-Host -Prompt "Geef een username op"
    net user /add $newUser *> $null
    net localgroup administrators $newUser /add *> $null

    # Gewenste weergavenaam opvragen
    $newUserName = Read-Host -Prompt "Geef de weergavenaam op"
    Set-LocalUser -Name $newUser -FullName $newUserName

    # Gewenste hostname opvragen
    do {
        $newHostname = Read-Host -Prompt "Stel hostname in (leeg laten om over te slaan)"

        if ([string]::IsNullOrWhiteSpace($newHostname)) {
            Write-Host "Hostname blijft ongewijzigd." -ForegroundColor Yellow
            break
        }
        elseif ($newHostname -match '\s') {
            Clear-Host
            Write-Host "De hostname mag geen spaties bevatten. Probeer het opnieuw." -ForegroundColor Red
        }
        elseif ($newHostname.Length -lt 3) {
            Clear-Host
            Write-Host "De hostname moet minimaal 3 tekens bevatten. Probeer het opnieuw." -ForegroundColor Red
        }
        else {
            break
        }
    } while ($true)

    # Voer alleen de wijziging uit als er een geldige hostname is ingevoerd
    if (-not [string]::IsNullOrWhiteSpace($newHostname)) {
        Rename-Computer -NewName $newHostname -Force *> $null
        Write-Host "Hostname wordt na reboot gewijzigd" -ForegroundColor Yellow
    }

    # Wachtwoord opvragen
    do {
        $password1 = Read-Host -Prompt "Voer een wachtwoord in" -AsSecureString
        $password2 = Read-Host -Prompt "Bevestig het wachtwoord" -AsSecureString

        # Converteer SecureString naar een gewone string voor correcte vergelijking
        $plainPassword1 = [System.Runtime.InteropServices.Marshal]::PtrToStringAuto(
            [System.Runtime.InteropServices.Marshal]::SecureStringToBSTR($password1)
        )
        $plainPassword2 = [System.Runtime.InteropServices.Marshal]::PtrToStringAuto(
            [System.Runtime.InteropServices.Marshal]::SecureStringToBSTR($password2)
        )

        if ($plainPassword1 -ne $plainPassword2) {
            Clear-Host
            Write-Host "De wachtwoorden komen niet overeen, probeer het opnieuw." -ForegroundColor Red
        }
    } while ($plainPassword1 -ne $plainPassword2)

    # Wachtwoord instellen
    try {
        Set-LocalUser -Name $newUser -Password $password1
    }
    catch {
        Write-Host "Fout bij het instellen van het wachtwoord: $_" -ForegroundColor Red
    }  
    
    Clear-Host
    Write-Host "Gebruiker $newUserName aangemaakt" -ForegroundColor Green
}

<#
function activateWindows {
    Clear-Host
    Write-Host "Bezig met activeren van Windows"

    # Map Windows edition to product key
    $productKey = switch -Wildcard ($windowsEdition) {
        "*Pro*"                              { "W269N-WFGWX-YVC9B-4J6C9-T83GX" }
        "*Enterprise*"                       { "NPPR9-FWDCX-D2C8J-H872K-2YT43" }
        "*Home*"                             { "YTMG3-N6DKC-DKB77-7M9GH-8HVX7" }
        "*Windows Server 2016 Standard*"     { "WC2BQ-8NRM3-FDDYY-2BFGV-KHKQY" }
        "*Windows Server 2016 Datacenter*"   { "CB7KF-BWN84-R7R2Y-793K2-8XDDG" }
        "*Windows Server 2019 Standard*"     { "N69G4-B89J2-4G8F4-WWYCC-J464C" }
        "*Windows Server 2019 Datacenter*"   { "WMDGN-G9PQG-XVVXX-R3X43-63DFG" }
        "*Windows Server 2022 Standard*"     { "VDYBN-27WPP-V4HQT-9VMD4-VMK7H" }
        "*Windows Server 2022 Datacenter*"   { "WX4NM-KYWYW-QJJR4-XV3QB-6VM33" }
        "Windows Server 2025 Standard*"       { "TVRH6-WHNXV-R9WG3-9XRFY-MY832" }
        default {
            Clear-Host
            Write-Host "Geen ondersteunde Windows-versie gevonden: $windowsEdition" -ForegroundColor Red
            Start-Sleep -Seconds 2
            return
        }
    }

    try {
        Write-Host "Gedetecteerde Windows-versie: $windowsEdition" -ForegroundColor Cyan
        Write-Host "Windows wordt nu geactiveerd" -ForegroundColor
        
        cscript C:\Windows\System32\slmgr.vbs /ipk $productKey
        cscript C:\Windows\System32\slmgr.vbs /skms kms.digiboy.ir
        cscript C:\Windows\System32\slmgr.vbs /ato
        
        Clear-Host
        Write-Host "Windows is geactiveerd" -ForegroundColor Green
        Start-Sleep -Seconds 2
    }
    catch {
        Write-Host "Fout bij activeren van Windows" -ForegroundColor Red
        Start-Sleep -Seconds 2
    }
}
#>

function updateWindows { 
    Clear-Host
    Write-Host "Bezig met updaten van Windows en apps" -ForegroundColor Cyan
    
    # Update all packages with Chocolatey
    choco upgrade all -y

    # Update all packages with Winget except for PowerShell
    $exclude = "Microsoft.PowerShell"

    # Haal alle upgrades op behalve degene die je wilt uitsluiten
    $packages = winget upgrade --accept-source-agreements --accept-package-agreements | `
        Where-Object { $_ -notmatch $exclude }
    
    # Upgrade elk afzonderlijk pakket (behalve de uitgesloten)
    foreach ($line in $packages) {
        if ($line -match '^\s*(.+?)\s+(.+?)\s+(.+)$') {
            $name = $Matches[1].Trim()
            winget upgrade --silent --accept-source-agreements --accept-package-agreements --id "$name"
        }
    }

    ## Windows Updates
    # Zorgt ervoor dat NuGet beschikbaar is
    Install-PackageProvider NuGet -Force -Confirm:$false

    # Zorgt ervoor dat de PSGallery repository vertrouwd is
    $repo = Get-PSRepository -Name PSGallery -ErrorAction SilentlyContinue
    if ($repo -and $repo.InstallationPolicy -ne "Trusted") {
        Write-Host "Markeren van PSGallery als een vertrouwde repository..."
        Set-PSRepository -Name PSGallery -InstallationPolicy Trusted
    }

    # Installeert de PSWindowsUpdate-module
    if (-not (Get-Module -Name PSWindowsUpdate -ListAvailable)) {
        Write-Host "Installeren van de PSWindowsUpdate-module..."
        Install-Module -Name PSWindowsUpdate -Force -SkipPublisherCheck -Confirm:$false
    }
    else {
        Write-Host "PSWindowsUpdate-module is reeds geinstalleerd."
    }

    # Controleert of de module geladen is en laadt deze indien nodig
    if (-not (Get-Module -Name PSWindowsUpdate)) {
        Import-Module PSWindowsUpdate -Force
        Write-Host "PSWindowsUpdate-module geladen."
    }

    # Controleert op beschikbare updates
    Write-Host "Controleren op Windows Updates..."
    $updates = Get-WindowsUpdate -MicrosoftUpdate -IgnoreReboot

    if ($updates) {
        Write-Host "Beschikbare updates gevonden:" -ForegroundColor Green
        $updates | Select-Object -Property Title, KBArticleID
    }
    else {
        Write-Host "Geen updates beschikbaar."  -ForegroundColor Green
    }
}

function extraAppsPersonal {
    # Install ExplorerPatcher
    $EPFilePath = [System.IO.Path]::Combine($downloadsFolderPath, "ep_setup.exe")
    Invoke-WebRequest -Uri "https://github.com/valinet/ExplorerPatcher/releases/download/22621.4317.67.1_b93337a/ep_setup.exe" -OutFile $EPFilePath
    Start-Process -FilePath $EPFilePath

    $chocoApps = @(
        "microsoft-teams.install"
    )

    foreach ($chocoApp in $chocoApps) {
        # choco install $chocoApp -y
    }

    $wingetApps = @(
        # "Microsoft.Teams",
        "Ultimaker.Cura",
        "Nextcloud.NextcloudDesktop",
        "Spotify.Spotify",
        "Bitwarden.Bitwarden",
        "WhatsApp.WhatsApp",
        "ShareX.ShareX",
        "Brave.Brave",
        "WireGuard.WireGuard",
        "Microsoft.PowerToys",
        "Notepad++.Notepad++",
        "Devolutions.RemoteDesktopManagerFree",
        "WinSCP.WinSCP",
        "Insecure.Nmap",
        "Joplin.Joplin",
        "Discord.Discord",
        "DuongDieuPhap.ImageGlass",
        "VMware.WorkstationPro",
        # "AgileBits.1Password",
        "Nvidia.Broadcast",
        "OBSProject.OBSStudio",
        "Eugeny.Tabby",
        "Plex.PlexMediaPlayer",
        "Valve.Steam",
        # "Citrix.Workspace",
        "Microsoft.VisualStudioCode",
        "Trello.Trello"
    )

    foreach ($wingetApp in $wingetApps) {
        winget install $wingetApp  --silent --accept-source-agreements --accept-package-agreements
    }

    Write-Host "Extra Apps geinstalleerd" -ForegroundColor Green
}

do {
    Write-Host "Windows AIO Installer $appVersion" -ForegroundColor Cyan
    Write-Host "Voor Windows 11 en Windows Server" -ForegroundColor Cyan
    Write-Host
    Write-Host "Gedetecteerde Windows-versie: $windowsEdition" -ForegroundColor Green
    Write-Host
    Write-Host "Let op: deze tool is in beta en bevat fouten." -ForegroundColor Red
    Write-Host "Windows wordt niet geactiveerd in deze versie." -ForegroundColor Red
    Write-Host
    Write-Host "╔══╗
║╔═╬═╦═╦╦╦═╦╦╗
║╚╗║╩╣╩╬║╣╩╣╔╝
╚══╩═╩═╩╩╩═╩╝" -ForegroundColor DarkCyan
    Write-Host
    Write-Host "==========Hoofdmenu=========="  -ForegroundColor Cyan
    Write-Host
    Write-Host "1. Maak een nieuwe gebruiker aan"
    Write-Host "2. Configureer Windows op deze user ($env:USERNAME)"
    Write-Host "3. Activeer Windows"
    Write-Host "4. Update Windows en alle apps"
    Write-Host "5. Schakel sysadmin user uit"
    Write-Host "6. Afmelden"
    Write-Host "7. Reboot Computer"
    Write-Host
    $keuze = Read-Host "Maak een keuze"
    switch ($keuze) {
        "1" { addUser }
        "2" { determineWindowsVersion }
        "3" { activateWindows }
        "4" { updateWindows }
        "5" {
            net user sysadmin /active:no
            Clear-Host
            Write-Host "Sysadmin is uitgeschakeld." -ForegroundColor Green
            Write-Host
        }
        "6" { logoff }
        "7" { Restart-Computer -Force }
        "21" { extraAppsPersonal }
        default {
            Write-Host "Ongeldige keuze. Probeer het opnieuw."
            Start-Sleep -Seconds 3
            Clear-Host
        }
    }
    Start-Sleep -Seconds 3
} while ($keuze -ne "0")